<?php
$slug = tenant_slug();
?>

<h2 class="text-lg font-semibold"><?= e(t('menu.trash')) ?></h2>

<?php if (!empty($ok)): ?>
  <div class="mt-3 rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-900 dark:border-emerald-900/40 dark:bg-emerald-950/30 dark:text-emerald-100">
    <?= e($ok) ?>
  </div>
<?php endif; ?>

<?php if (!empty($err)): ?>
  <div class="mt-3 rounded-xl border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-900 dark:border-red-900/40 dark:bg-red-950/30 dark:text-red-100">
    <?= e($err) ?>
  </div>
<?php endif; ?>

<div class="mt-4 grid grid-cols-1 gap-4 lg:grid-cols-2">

  <!-- Documents -->
  <div class="rounded-2xl border border-slate-200 p-4 dark:border-slate-800 lg:col-span-2">
    <div class="font-semibold">Belgeler (Fatura / Teklif)</div>
    <div class="mt-3 overflow-auto">
      <table class="min-w-full text-sm">
        <thead class="text-left text-xs text-slate-500 dark:text-slate-400">
          <tr>
            <th class="py-2 pr-3">Tür</th>
            <th class="py-2 pr-3">Belge No</th>
            <th class="py-2 pr-3">Silinme</th>
            <th class="py-2 pr-3">İşlem</th>
          </tr>
        </thead>
        <tbody class="divide-y divide-slate-100 dark:divide-slate-800">
        <?php foreach (($documents ?? []) as $r): ?>
          <tr>
            <td class="py-2 pr-3"><?= e((string)$r['type']) ?></td>
            <td class="py-2 pr-3 font-medium"><?= e((string)$r['doc_no']) ?></td>
            <td class="py-2 pr-3"><?= e((string)$r['deleted_at']) ?></td>
            <td class="py-2 pr-3 flex gap-2">
              <form method="post" action="<?= e(base_path('/'.$slug.'/trash/restore')) ?>">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="kind" value="document">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="rounded-lg border border-slate-200 px-3 py-1 text-xs hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">Geri Al</button>
              </form>
              <form method="post" action="<?= e(base_path('/'.$slug.'/trash/delete')) ?>">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="kind" value="document">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="rounded-lg border border-red-200 px-3 py-1 text-xs text-red-700 hover:bg-red-50 dark:border-red-900/40 dark:text-red-200 dark:hover:bg-red-950/30">Kalıcı Sil</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
      <?php if (empty($documents)): ?>
        <div class="mt-3 text-sm text-slate-500 dark:text-slate-400">Boş.</div>
      <?php endif; ?>
    </div>
  </div>

  <!-- Customers -->
  <div class="rounded-2xl border border-slate-200 p-4 dark:border-slate-800">
    <div class="font-semibold">Müşteriler</div>
    <div class="mt-3 overflow-auto">
      <table class="min-w-full text-sm">
        <thead class="text-left text-xs text-slate-500 dark:text-slate-400">
          <tr><th class="py-2 pr-3">Ad</th><th class="py-2 pr-3">Silinme</th><th class="py-2 pr-3">İşlem</th></tr>
        </thead>
        <tbody class="divide-y divide-slate-100 dark:divide-slate-800">
        <?php foreach (($customers ?? []) as $r): ?>
          <tr>
            <td class="py-2 pr-3 font-medium"><?= e((string)$r['name']) ?></td>
            <td class="py-2 pr-3"><?= e((string)$r['deleted_at']) ?></td>
            <td class="py-2 pr-3 flex gap-2">
              <form method="post" action="<?= e(base_path('/'.$slug.'/trash/restore')) ?>">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="kind" value="customer">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="rounded-lg border border-slate-200 px-3 py-1 text-xs hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">Geri Al</button>
              </form>
              <form method="post" action="<?= e(base_path('/'.$slug.'/trash/delete')) ?>">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="kind" value="customer">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="rounded-lg border border-red-200 px-3 py-1 text-xs text-red-700 hover:bg-red-50 dark:border-red-900/40 dark:text-red-200 dark:hover:bg-red-950/30">Kalıcı Sil</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
      <?php if (empty($customers)): ?><div class="mt-3 text-sm text-slate-500 dark:text-slate-400">Boş.</div><?php endif; ?>
    </div>
  </div>

  <!-- Products -->
  <div class="rounded-2xl border border-slate-200 p-4 dark:border-slate-800">
    <div class="font-semibold">Ürünler</div>
    <div class="mt-3 overflow-auto">
      <table class="min-w-full text-sm">
        <thead class="text-left text-xs text-slate-500 dark:text-slate-400">
          <tr><th class="py-2 pr-3">Ad</th><th class="py-2 pr-3">Silinme</th><th class="py-2 pr-3">İşlem</th></tr>
        </thead>
        <tbody class="divide-y divide-slate-100 dark:divide-slate-800">
        <?php foreach (($products ?? []) as $r): ?>
          <tr>
            <td class="py-2 pr-3 font-medium"><?= e((string)$r['name']) ?></td>
            <td class="py-2 pr-3"><?= e((string)$r['deleted_at']) ?></td>
            <td class="py-2 pr-3 flex gap-2">
              <form method="post" action="<?= e(base_path('/'.$slug.'/trash/restore')) ?>">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="kind" value="product">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="rounded-lg border border-slate-200 px-3 py-1 text-xs hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">Geri Al</button>
              </form>
              <form method="post" action="<?= e(base_path('/'.$slug.'/trash/delete')) ?>">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="kind" value="product">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="rounded-lg border border-red-200 px-3 py-1 text-xs text-red-700 hover:bg-red-50 dark:border-red-900/40 dark:text-red-200 dark:hover:bg-red-950/30">Kalıcı Sil</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
      <?php if (empty($products)): ?><div class="mt-3 text-sm text-slate-500 dark:text-slate-400">Boş.</div><?php endif; ?>
    </div>
  </div>

</div>
